// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the UHFDLL_EXPORTS
// symbol defined on the command line. This symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// UHFDLL_API functions as being imported from a DLL, whereas this DLL sees symbols
// defined with this macro as being exported.
#ifdef UHFDLL_EXPORTS
#define UHFDLL_API __declspec(dllexport) __cdecl
#else
#define UHFDLL_API __declspec(dllimport) __cdecl
#endif

#define TAG_DATA_SIZE		256

/* Tag data struct type */
typedef struct {
	UINT32	tagIndex;					/* record for the row of tag table */
	UINT8	rssi;						/* receive rssi */
	UINT32	freq;						/* receive frequency */
	UINT16	reflectPower;				/* reflected power */
	UINT8	data[TAG_DATA_SIZE];		/* tag data area */
	UINT8	dataLen;					/* tag data length */
} TagDataStructType;

extern "C" BOOL UHFDLL_API AS3992_Connect(UINT32 port, ULONG baudrate);

extern "C" BOOL UHFDLL_API AS3992_Disconnect();

extern "C" BOOL UHFDLL_API AS3992_CallAntennaPower();

extern "C" void UHFDLL_API AS3992_CallInventoryRSSI_Single(void (CALLBACK *callBack)(TagDataStructType *));

extern "C" void UHFDLL_API AS3992_CallInventoryRSSI_Stop(void (CALLBACK *callBack)(TagDataStructType *));

extern "C" BOOL UHFDLL_API AS3992_CallSelectTag(UINT8 *epc, UINT8 epclen);

extern "C" BOOL UHFDLL_API AS3992_CallWriteTag(UINT8 mem_type, UINT8 addr, UINT8 *password, UINT8 *data, UINT8 datalen, UINT8 *retstatus);

extern "C" BOOL UHFDLL_API AS3992_CallReadFromTag(UINT8 mem_type, UINT8 addr, UINT8 datalen, UINT8 *retstatus, UINT8 *retdata, UINT8 *retdatalen);

extern "C" BOOL UHFDLL_API AS3992_CallConfigRFPower(UINT8 attenuation, UINT8 *cur_attenuation);

extern "C" BOOL UHFDLL_API AS3992_CallSetSensitivity(UINT8 sensitivity, UINT8 *cur_sensitivity);